/*
 *  Kod z ksiki
 *  Programowanie w jzyku C. FAQ
 *  Addison-Wesley, 1996, ISBN 0-201-84519-9
 *  (pytanie 7.30)
 *
 *  Copyright Steve Summit, 1995
 *  Ten kod moe by dowolnie uywany lub modyfikowany, bd wdziczny 
 *  za podanie rda. Nie daj jednak adnej gwarancji jego dziaania, 
 *  ani nie przyjmuj adnej odpowiedzialnoci za skutki jego 
 *  wykorzystania.
 */

#include <stdio.h>
#include <stdlib.h>

/* wczytuje wiersz z pliku fp do pamici przydzielonej dynamicznie */
/* zwraca NULL w przypadku koca pliku lub bedu */
/* (uyj feof albo ferror, eby rozrni) */

char *agetline(FILE *fp)
{
	char *retbuf = NULL;
	size_t nchmax = 0;
	register int c;
	size_t nchread = 0;
	char *newbuf;

	while((c = getc(fp)) != EOF) {
		if(nchread >= nchmax) {
			nchmax += 20;
#ifdef SAFEREALLOC
			newbuf = realloc(retbuf, nchmax + 1);
#else
			if(retbuf == NULL)	/* realloc niezgodne z ANSI */
				newbuf = malloc(nchmax + 1);
			else	newbuf = realloc(retbuf, nchmax + 1);
#endif
						/* +1 dla \0 */
			if(newbuf == NULL) {
				free(retbuf);
				return NULL;
			}

			retbuf = newbuf;
		}

		if(c == '\n')
			break;

		retbuf[nchread++] = c;
	}

	if(retbuf != NULL) {
		retbuf[nchread] = '\0';

		newbuf = realloc(retbuf, nchread + 1);
		if(newbuf != NULL)
			retbuf = newbuf;
	}

	return retbuf;
}
